<?php
include "include/header.php";
?>


      <section class="main-banner">
         <div class="container">
            <div class="wrap-banner-text">
               <div class="banner-text" data-aos="zoom-in-left" data-aos-duration="2000">
                  <h1 class="exh">Professional Book<br><span>Writing Services in USA</span></h1>
                  <p>Looking for professional book-writing services? Look no further! Our team of Oxford Publishing Writers can help you with every aspect of your book, from crafting the plot to designing, publishing, and marketing your work.</p>
               </div>
               <div class="banner-tab-wrap" data-aos="fade-left" data-aos-duration="2000">
                  <div class="row banner-tab-slider">
                     <div class="col-lg-4 col-md-12 col-sm-12">
                        <div class="banner-tab">
                           <img src="images/webp/banner-icon-1.webp" alt="" class="img-fluid">
                           <h3>Compelling Content</h3>
                           <p>We will write engaging content that can captivate your audience. Contact us for your content needs.</p>
                        </div>
                     </div>
                     <div class="col-lg-4 col-md-12 col-sm-12">
                        <div class="banner-tab">
                           <img src="images/webp/banner-icon-2.webp" alt="" class="img-fluid">
                           <h3>Skilled Authors</h3>
                           <p>With our highly qualified writers, we can write about anything and everything.</p>
                        </div>
                     </div>
                     <div class="col-lg-4 col-md-12 col-sm-12">
                        <div class="banner-tab">
                           <img src="images/webp/banner-icon-3.webp" alt="" class="img-fluid">
                           <h3>Expert Writing</h3>
                           <p>Our top-quality content writing solutions cater to diverse fields and industries, delivering exceptional results every time.</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <section class="main-about">
         <div class="container">
            <div class="row">
               <div class="col-lg-5 col-md-5 col-sm-5">
                  <div class="main-about-img" data-aos="flip-left" data-aos-duration="2000">
                     <img src="images/webp/about-img.webp" alt="" class="img-fluid">
                  </div>
               </div>
               <div class="col-lg-7 col-md-12 col-sm-12">
                  <div class="wrap-about-text" data-aos="fade-left" data-aos-duration="2000">
                     <h3>About</h3>
                     <p>If you're seeking a ghostwriting service that maintains top-notch quality, Oxford University Writers is the perfect solution for you. With over a decade of experience, our US-based agency has assisted countless authors in realizing their aspirations and reaching their goals. We craft captivating narratives and articulate ideas with precision, ensuring that your readers are taken on a memorable journey. Let us bring your stories and concepts to life in a way that leaves a lasting impact.</p>
                     <div class="about-tab-carousel owl-carousel owl-theme">
                        <div class="item">
                           <div class="about-tab-text">
                              <h2>Our Authors</h2>
                              <p>Our team at Oxford Publishing Writers consists of the best writers from diverse fields, who excel in their craft.</p>
                           </div>
                        </div>
                        <div class="item">
                           <div class="about-tab-text">
                              <h2>Our Proofreaders & Editors</h2>
                              <p>Our editing and proofreading team is dedicated to delivering flawless content, leaving no stone unturned.</p>
                           </div>
                        </div>
                        <div class="item">
                           <div class="about-tab-text">
                              <h2>Our Consultants</h2>
                              <p>Our team of friendly consultants are always available to address your queries and concerns with a cooperative approach.</p>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <section class="main-service">
         <div class="container">
            <div class="row">
               <div class="col-lg-4 col-md-12 col-sm-12">
                  <div class="service-text" data-aos="zoom-in-right" data-aos-duration="2000">
                     <h3>Services</h3>
                     <p>At our writing agency, we provide a wide range of comprehensive services that cater to all your content needs. Our professionally written content is not only 100% original and plagiarism-free, but also grammatically precise.</p>
                  </div>
               </div>
               <div class="col-lg-8 col-md-12 col-sm-12">
                  <div class="main-service-tab" data-aos="zoom-out-up" data-aos-duration="2000">
                     <div class="slick-wrapper">
                        <div id="slick1">
                           <div class="slide-item">
                              <div class="service-tab-text">
                                 <img src="images/webp/service-icon-1.webp" alt="" class="img-fluid">
                                 <h3>GhostWriting</h3>
                                 <p>Let our skilled writers bring your book idea to fruition. We capture your voice and turn your vision into reality.</p>
                              </div>
                           </div>
                           <div class="slide-item">
                              <div class="service-tab-text">
                                 <img src="images/webp/service-icon-2.webp" alt="" class="img-fluid">
                                 <h3>Book Publishing</h3>
                                 <p>We simplify the publishing process for our clients, ensuring their books are professionally published and listed for sale on their preferred online platforms.</p>
                              </div>
                           </div>
                           <div class="slide-item">
                              <div class="service-tab-text">
                                 <img src="images/webp/service-icon-3.webp" alt="" class="img-fluid">
                                 <h3>Book Marketing</h3>
                                 <p>Maximize sales and reach your audience with our book marketing expertise. Simplify online promotion with our services.</p>
                              </div>
                           </div>
                           <div class="slide-item">
                              <div class="service-tab-text">
                                 <img src="images/webp/service-icon-4.webp" alt="" class="img-fluid">
                                 <h3>Proofreading</h3>
                                 <p>Reach the finish line with flawless content. Hire our professional proofreading services at Oxford Publishing Writers for error-free manuscripts and content.</p>
                              </div>
                           </div>
                           <div class="slide-item">
                              <div class="service-tab-text">
                                 <img src="images/webp/service-icon-1.webp" alt="" class="img-fluid">
                                 <h3>Cover Design</h3>
                                 <p>Get a stunning book cover for your masterpiece with the help of our skilled designers. You decide, we create.</p>
                              </div>
                           </div>
                           <div class="slide-item">
                              <div class="service-tab-text">
                                 <img src="images/webp/service-icon-2.webp" alt="" class="img-fluid">
                                 <h3>Formatting</h3>
                                 <p>Our expert editors, all native English speakers, ensure your book is formatted correctly, so your writing makes sense and delivers the intended message.</p>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <section class="main-protfolio" >
         <div class="container">
            <div class="portfolio-heading" data-aos="fade-down-right" data-aos-duration="2000">
               <h3>Our Works</h3>
               <p>Have a look at some of our prestigious bestsellers.</p>
            </div>
			<div class="portfolio-box-wrap" data-aos="fade-up" data-aos-duration="2000">
               <div class="row">
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/1.webp" alt="" class="img-fluid">
                  </div>
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/2.webp" alt="" class="img-fluid">
                  </div>
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/3.webp" alt="" class="img-fluid">
                  </div>
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/4.webp" alt="" class="img-fluid">
                  </div>
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/5.webp" alt="" class="img-fluid">
                  </div>
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/6.webp" alt="" class="img-fluid">
                  </div>
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/7.webp" alt="" class="img-fluid">
                  </div>
                  <div class="col-md-3">
                     <img src="images/webp/home-portfolio/8.webp" alt="" class="img-fluid">
                  </div>
               </div>
            </div>
            <!-- <div class="portfolio-box-wrap" data-aos="fade-up" data-aos-duration="2000">
               <div class="portfolio-slider owl-carousel owl-theme">
                  <div class="item">
                     <img src="images/webp/home-portfolio/1.webp" alt="" class="img-fluid">
                  </div>
                  <div class="item">
                     <img src="images/webp/home-portfolio/2.webp" alt="" class="img-fluid">
                  </div>
                  <div class="item">
                     <img src="images/webp/home-portfolio/3.webp" alt="" class="img-fluid">
                  </div>
                  <div class="item">
                     <img src="images/webp/home-portfolio/4.webp" alt="" class="img-fluid">
                  </div>
                  <div class="item">
                     <img src="images/webp/home-portfolio/5.webp" alt="" class="img-fluid">
                  </div>
                  <div class="item">
                     <img src="images/webp/home-portfolio/6.webp" alt="" class="img-fluid">
                  </div>
                  <div class="item">
                     <img src="images/webp/home-portfolio/7.webp" alt="" class="img-fluid">
                  </div>
                  <div class="item">
                     <img src="images/webp/home-portfolio/8.webp" alt="" class="img-fluid">
                  </div>
               </div>
            </div> -->
            <!-- <div class="main-counter" data-aos="zoom-out" data-aos-duration="2000">
                <h3>Facts and Figures</h3>
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <div class="counter-tab">
                            <div class="dots-text counter">                
                                <span class="timer count-num count-title count-number" data-to="2900" data-speed="1500">2900+</span>
                            </div>
                            <h2>Happy Clients</h2>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <div class="counter-tab">
                            <div class="dots-text counter">                
                                <span class="timer count-num count-title count-number" data-to="1800" data-speed="1500">1800+</span>
                            </div>
                            <h2>Projects Completed</h2>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <div class="counter-tab">
                            <div class="dots-text counter">                
                                <span class="timer count-num count-title count-number" data-to="700" data-speed="1500">700+</span>
                            </div>
                            <h2>Industries Served</h2>
                        </div>
                    </div>
                </div>
            </div>  -->
         </div>
      </section>
      <section class="main-avenue home-avanue" data-aos="flip-up" data-aos-duration="2000">
         <div class="container">
            <div class="avenue-heading">
               <h3>With Oxford Publishing Writers You Can:</h3>
            </div>
            <div class="row avenue-slider">
               <div class="col-lg-3 col-md-12 col-sm-12">
                  <div class="avenue-tab">
                     <img src="images/webp/avenue-icon-1.webp" alt="" class="img-fluid">
                     <p>Get rid of the daily struggle of writing with our services.</p>
                  </div>
               </div>
               <div class="col-lg-3 col-md-12 col-sm-12">
                  <div class="avenue-tab">
                     <img src="images/webp/avenue-icon-2.webp" alt="" class="img-fluid">
                     <p>Get impeccable content crafted by skilled writers.</p>
                  </div>
               </div>
               <div class="col-lg-3 col-md-12 col-sm-12">
                  <div class="avenue-tab">
                     <img src="images/webp/avenue-icon-3.webp" alt="" class="img-fluid">
                     <p>Get high-quality content tailored to your niche.</p>
                  </div>
               </div>
               <div class="col-lg-3 col-md-12 col-sm-12">
                  <div class="avenue-tab">
                     <img src="images/webp/avenue-icon-4.webp" alt="" class="img-fluid">
                     <p>Achieve your dream of becoming a bestseller with us.</p>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <br>
      <section class="main-choose-us">
         <div class="container">
            <div class="row">
               <div class="col-lg-7 col-md-12 col-sm-12" data-aos="fade-down" data-aos-duration="2000">
                  <div class="why-choose-text">
                     <h3>Why Choose Us</h3>
                  </div>
                  <div class="wrap-why-choose">
                     <div id="accordion" class="myaccordion">
                        <div class="card">
                           <div class="card-header" id="headingOne">
                              <h2 class="mb-0">
                                 <button class="d-flex align-items-center justify-content-between btn btn-link" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                 Top-tier Writing Experts
                                 <span class="fa-stack fa-sm">
                                 <i class="fas fa-minus fa-stack-1x fa-inverse"></i>
                                 </span>
                                 </button>
                              </h2>
                           </div>
                           <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordion">
                              <div class="card-body">
                                 <p>Our team of expert writers can tackle books of all genres, including business and literature, ensuring a professional and engaging result.</p>
                              </div>
                           </div>
                        </div>
                        <div class="card">
                           <div class="card-header" id="headingTwo">
                              <h2 class="mb-0">
                                 <button class="d-flex align-items-center justify-content-between btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                 Flawless Writing Quality
                                 <span class="fa-stack fa-2x">
                                 <i class="fas fa-plus fa-stack-1x fa-inverse"></i>
                                 </span>
                                 </button>
                              </h2>
                           </div>
                           <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion">
                              <div class="card-body">
                                 <p>Our writers, editors, and proofreaders ensure flawless content that takes readers on a smooth journey through your book.</p>
                              </div>
                           </div>
                        </div>
                        <div class="card">
                           <div class="card-header" id="headingThree">
                              <h2 class="mb-0">
                                 <button class="d-flex align-items-center justify-content-between btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                 Always Available Assistance 
                                 <span class="fa-stack fa-2x">
                                 <i class="fas fa-plus fa-stack-1x fa-inverse"></i>
                                 </span>
                                 </button>
                              </h2>
                           </div>
                           <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion">
                              <div class="card-body">
                                 <p>Need help? Our expert consultants are available 24/7 to address and solve any queries you may have.</p>
                              </div>
                           </div>
                        </div>
                        <!-- <div class="card">
                           <div class="card-header" id="headingfour">
                              <h2 class="mb-0">
                                 <button class="d-flex align-items-center justify-content-between btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                 Unlimited Revisions
                                 <span class="fa-stack fa-2x">
                                 <i class="fas fa-plus fa-stack-1x fa-inverse"></i>
                                 </span>
                                 </button>
                              </h2>
                           </div>
                           <div id="collapsefour" class="collapse" aria-labelledby="headingfour" data-parent="#accordion">
                              <div class="card-body">
                                 <p>We offer unlimited revisions to our prestigious clients as customer satisfaction and building a long-term relationship with our clients is our top most priority.</p>
                              </div>
                           </div>
                        </div> -->
                     </div>
                  </div>
               </div>
               <div class="col-lg-5 col-md-12 col-sm-12">
                  <div class="why-choose-img" data-aos="flip-right" data-aos-duration="2000">
                     <img src="images/webp/choose-banner.webp" alt="" class="img-fluid">
                  </div>
               </div>
            </div>
         </div>
      </section>
          <section class="main-testi">
        <div class="container">
            <div id="demo" class="carousel slide" data-ride="carousel" data-aos="fade-down" data-aos-duration="2000">
              <!-- The slideshow -->
              <div class="carousel-inner">
                <div class="carousel-item active">
                    <div class="testi-text">
                        <p>Thanks to this team, my book became a New York Times Bestseller in 2019. It was a pleasure working with them.<span>- Emma Williams -</span></p>
                    </div>
                </div>
                <div class="carousel-item">
                  <div class="testi-text">
                        <p>I placed an order with them to write a book for me and I was surprised by the quality of writing and the reader’s response to my book. I will surely place more orders with them.<span>- Miranda Kess -</span></p>
                    </div>
                </div>
                <div class="carousel-item">
                 <div class="testi-text">
                        <p>I would highly recommend Oxford Publishing Writers for all of your publishing and editing needs. Not only is the work of high professional quality, but their turn-around time is excellent.<span>- Danielle Pete -</span></p>
                    </div>
                </div>
                 <div class="carousel-item">
                 <div class="testi-text">
                        <p>My book needed editing and I was 6 weeks away from my book launch. I hired these guys to edit my book for me and they did a great job with it.<span>- Gabriella Clarke -</span></p>
                    </div>
                </div>
                
                <div class="carousel-item">
                 <div class="testi-text">
                        <p>I was struggling with writing articles for my client and was about to lose him. Oxford Publishing Writers proved to be a lifesaving service as these guys wrote 10 articles for me within 2 days. I just love their service!<span>- Simona Fray -</span></p>
                    </div>
                </div>

                <div class="carousel-item">
                 <div class="testi-text">
                        <p>I am glad that I decided to place my bookwriting order with these guys. The project went by real smooth and I love the book they wrote.<span>- Sarah Williams -</span></p>
                    </div>
                </div>
                <div class="carousel-item">
                 <div class="testi-text">
                        <p>The team behind Oxford Publishing Writers is simply the best. I got my Wikipedia page made by them and the process was completely hassle-free. It has been 4 months that my Wikipedia page is up and running, and I haven't had a single problem with it.<span>- Henry Ermond -</span></p>
                    </div>
                </div>
                <div class="carousel-item">
                 <div class="testi-text">
                        <p>I’ve been in the writing profession since years and have worked with a number of companies but this one is truly amazing. Their writers are well qualified with incredible writing styles and they deliver work on time. No delays at all!<span>- David Franqui -</span></p>
                    </div>
                </div>
                 
              </div>
              <!-- Indicators -->
              <div class="carousel-indicators">
                <div data-target="#demo" data-slide-to="0" class="active">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-1.webp" alt="" class="img-fluid">
                    </div>
                </div>
                <div data-target="#demo" data-slide-to="1">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-2.webp" alt="" class="img-fluid">
                    </div>
                </div>
                <div data-target="#demo" data-slide-to="2">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-3.webp" alt="" class="img-fluid">
                    </div>
                </div>
                <div data-target="#demo" data-slide-to="3">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-4.webp" alt="" class="img-fluid">
                    </div>
                </div>

                <div data-target="#demo" data-slide-to="4">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-5.webp" alt="" class="img-fluid">
                    </div>
                </div>

                <div data-target="#demo" data-slide-to="5">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-6.webp" alt="" class="img-fluid">
                    </div>
                </div>

                <div data-target="#demo" data-slide-to="6">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-7.webp" alt="" class="img-fluid">
                    </div>
                </div>

                <div data-target="#demo" data-slide-to="7">
                    <div class="testi-icon">
                        <img src="images/webp/testimonial-8.webp" alt="" class="img-fluid">
                    </div>
                </div>
               
              </div>

            </div>
        </div>
    </section> 
          <section class="main-client" data-aos="zoom-out" data-aos-duration="2000">
        <div class="container">
            <div class="client-heading">
                <h3>OUR AUTHORS IN THE NEWS</h3>
                <p>Our team of experienced and bestselling writers, book writers and editors from multiple industries are frequently featured in the top-notch media for their remarkable expertise.</p>
            </div>
            <div class="client-logo-slider owl-carousel owl-theme">
                <div class="item">
                    <img src="images/webp/client-logo-1.webp" alt="" class="img-fluid">
                </div>
                <div class="item">
                    <img src="images/webp/client-logo-2.webp" alt="" class="img-fluid">
                </div>
            </div>
        </div>  
    </section> 
      
<?php
include "include/footer.php";
?>